/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.core.io.events.ConnectionPointEvent;
import com.aptana.ide.core.io.events.IConnectionPointListener;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.core.SiteConnectionUtils;
import com.aptana.ide.syncing.core.SyncingPlugin;
import com.aptana.ide.syncing.core.events.ISiteConnectionListener;
import com.aptana.ide.syncing.core.events.SiteConnectionEvent;
import com.aptana.ide.syncing.ui.actions.DownloadAction;
import com.aptana.ide.syncing.ui.actions.Sync;
import com.aptana.ide.syncing.ui.editors.EditorUtils;
import com.aptana.ide.syncing.ui.navigator.ProjectSitesManager;
import com.aptana.ide.syncing.ui.preferences.IPreferenceConstants;
import com.aptana.ide.syncing.ui.preferences.SyncPreferenceUtil;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.IUniformFileStoreEditorInput;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SyncingUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.syncing.ui";
    private static SyncingUIPlugin plugin;
    private ISiteConnectionListener connectionListener = new ISiteConnectionListener(){

        public void siteConnectionChanged(SiteConnectionEvent event) {
            ISiteConnection siteConnection = event.getSiteConnection();
            switch (event.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    EditorUtils.closeConnectionEditor(siteConnection);
                }
            }
            SyncingUIPlugin.refreshProjectSiteConnection(siteConnection);
        }
    };
    private IConnectionPointListener connectionPointListener = new IConnectionPointListener(){

        public void connectionPointChanged(ConnectionPointEvent event) {
            IConnectionPoint connectionPoint = event.getConnectionPoint();
            switch (event.getKind()) {
                case 1: {
                    ISiteConnection[] sites = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                    String id = connectionPoint.getId();
                    ISiteConnection[] iSiteConnectionArray = sites;
                    int n = sites.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConnectionPoint destination;
                        ISiteConnection site = iSiteConnectionArray[n2];
                        IConnectionPoint source = site.getSource();
                        if (source != null && source.getId().equals(id)) {
                            site.setSource(connectionPoint);
                        }
                        if ((destination = site.getDestination()) != null && destination.getId().equals(id)) {
                            site.setDestination(connectionPoint);
                            SyncingUIPlugin.refreshProjectSiteConnection(site);
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    ISiteConnection[] siteConnections;
                    ISiteConnection[] iSiteConnectionArray = siteConnections = SyncingPlugin.getSiteConnectionManager().getSiteConnections();
                    int n = siteConnections.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ISiteConnection siteConnection = iSiteConnectionArray[n3];
                        if (siteConnection.getDestination() == connectionPoint) {
                            SyncingUIPlugin.refreshProjectSiteConnection(siteConnection);
                        }
                        ++n3;
                    }
                    break;
                }
            }
        }
    };
    private IExecutionListener fExecutionListener = new IExecutionListener(){
        private static final String COMMAND_SAVE = "org.eclipse.ui.file.save";
        private static final String COMMAND_SAVE_ALL = "org.eclipse.ui.file.saveAll";
        private List<IFileEditorInput> editorInputsToUpload = new ArrayList<IFileEditorInput>();
        private List<IUniformFileStoreEditorInput> editorInputsToDownload = new ArrayList<IUniformFileStoreEditorInput>();

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            if (COMMAND_SAVE.equals(commandId) || COMMAND_SAVE_ALL.equals(commandId)) {
                for (IFileEditorInput iFileEditorInput : this.editorInputsToUpload) {
                    IProject project = iFileEditorInput.getFile().getProject();
                    if (!SyncPreferenceUtil.isAutoSync(project) || SyncPreferenceUtil.getAutoSyncDirection(project) == IPreferenceConstants.SyncDirection.DOWNLOAD) continue;
                    Sync.uploadEditor((IEditorInput)iFileEditorInput);
                }
                for (IUniformFileStoreEditorInput iUniformFileStoreEditorInput : this.editorInputsToDownload) {
                    ISiteConnection[] sites;
                    ISiteConnection[] iSiteConnectionArray = sites = SiteConnectionUtils.findSitesWithDestination((IAdaptable)iUniformFileStoreEditorInput);
                    int n = sites.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project;
                        ISiteConnection site = iSiteConnectionArray[n2];
                        IConnectionPoint source = site.getSource();
                        if (source instanceof WorkspaceConnectionPoint && SyncPreferenceUtil.isAutoSync(project = ((WorkspaceConnectionPoint)source).getResource().getProject()) && SyncPreferenceUtil.getAutoSyncDirection(project) != IPreferenceConstants.SyncDirection.UPLOAD) {
                            DownloadAction action = new DownloadAction();
                            action.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                            action.setSelection((ISelection)new StructuredSelection((Object)iUniformFileStoreEditorInput), false);
                            action.run(null);
                        }
                        ++n2;
                    }
                }
            }
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            IEditorPart[] editorsToTransfer = null;
            this.editorInputsToUpload.clear();
            this.editorInputsToDownload.clear();
            if (COMMAND_SAVE.equals(commandId)) {
                editorsToTransfer = new IEditorPart[]{UIUtils.getActiveEditor()};
            } else if (COMMAND_SAVE_ALL.equals(commandId)) {
                editorsToTransfer = UIUtils.getDirtyEditors();
            }
            if (editorsToTransfer != null) {
                IEditorPart[] iEditorPartArray = editorsToTransfer;
                int n = editorsToTransfer.length;
                int n2 = 0;
                while (n2 < n) {
                    IUniformFileStoreEditorInput editorInput;
                    IEditorPart editor = iEditorPartArray[n2];
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        this.editorInputsToUpload.add((IFileEditorInput)input);
                    } else if (input instanceof IUniformFileStoreEditorInput && (editorInput = (IUniformFileStoreEditorInput)input).isRemote()) {
                        this.editorInputsToDownload.add(editorInput);
                    }
                    ++n2;
                }
            }
        }
    };

    private static void refreshProjectSiteConnection(ISiteConnection siteConnection) {
        IContainer container;
        IConnectionPoint source = siteConnection.getSource();
        if (source != null && (container = (IContainer)source.getAdapter(IContainer.class)) != null) {
            IOUIPlugin.refreshNavigatorView((Object)((Object)ProjectSitesManager.getInstance().getProjectSites(container.getProject())));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SyncingPlugin.getSiteConnectionManager().addListener(this.connectionListener);
        CoreIOPlugin.getConnectionPointManager().addConnectionPointListener(this.connectionPointListener);
        this.addCommandSaveListener();
    }

    public void stop(BundleContext context) throws Exception {
        SyncingPlugin.getSiteConnectionManager().removeListener(this.connectionListener);
        CoreIOPlugin.getConnectionPointManager().removeConnectionPointListener(this.connectionPointListener);
        this.removeCommandSaveListener();
        plugin = null;
        super.stop(context);
    }

    public static SyncingUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String path) {
        ImageRegistry registry = plugin.getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ImageDescriptor id = SyncingUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    private void addCommandSaveListener() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener(this.fExecutionListener);
        }
    }

    private void removeCommandSaveListener() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.removeExecutionListener(this.fExecutionListener);
        }
    }
}

